import no.uib.cipr.matrix.sparse.*;
import no.uib.cipr.matrix.io.*;
import no.uib.cipr.matrix.distributed.*;
import no.uib.cipr.matrix.Vector;

import org.ini4j.spi.*;
import org.ini4j.*;

///
/// CS-583: Introduction to Computer Vision
/// https://www.cs.drexel.edu/~kon/introcompvis/
///
/// Project 1 - Homography
///
/// Author: Matthew Patchin
///


// Needed for the various Matrix and Vector operations
import no.uib.cipr.matrix.*;
// Needed for functions like Max and Min
import java.lang.Math.*;
// Needed for the .ini file parsing
import org.ini4j.Ini;

// ini file reading constants including filename and key names
static final String INI_FILE = "homography.ini";
static final String SOURCE_IMAGE = "sourceImage";
static final String SOURCE_POINTS = "sourcePoints";
static final String TARGET_POINTS = "targetPoints";
static final String TARGET_IMAGE = "targetImage";
static final String SOURCE_MASK = "sourceMask";
static final String OUTPUT_IMAGE = "outputFile";

// Homographic indexes
static final int X = 0;
static final int Y = 1;
static final int Z = 2;

// Whether or not to print debug information
static final boolean DEBUG = true;

// How long to wait in between intermediate screen displays in ms
static final int FRAME_DELAY = 1000;  // 1 second
static final int FINAL_DELAY = 5000; // 5 seconds
static final int MS_PER_SEC = 1000; // 1000 ms / sec

// Size of red dot to draw. Used in showPoints
static final int DOT_SIZE = 10;


///
/// Set up screen size, turn off re-drawing loop
///
void setup() {
  size(400, 400); // size(screen.width, screen.height); // fullscreen
  noLoop();
}


///
/// Main function
///
void draw() {
  // Read .ini file
  Ini parameters = new Ini();
  try {
    BufferedReader reader = createReader(INI_FILE);
    if(reader == null) {
      throw new FileNotFoundException("ini file not found");
    }

    parameters.load(reader);

    // Iterate through sections of file
    Set sections = parameters.entrySet();
    Iterator sectionIterator = sections.iterator();
    while(sectionIterator.hasNext()) {
      Map.Entry e = (Map.Entry)sectionIterator.next();
      Ini.Section section = (Ini.Section)e.getValue();
      
      // TODO: Read each section to get the various possible input values
      // see: Entry::getKey() and section::get()
      
      String task = (String)e.getKey();
      String imageSource = section.get("sourceImage");
      String sourcePoints = section.get("sourcePoints");
      String targetPoints = section.get("targetPoints");
      String saveDestination = section.get("outputFile");
      String imageTarget = section.get("targetImage");
      /*
      println(task);
      println("src image is " + imageSource);
      println("src points is " + sourcePoints);
      println("target points is " + targetPoints);
      println("outputFile is " + saveDestination);
      println("targetFile id " + imageTarget);
      */
      // TODO: Fork to do compositing or rectification based on which values are set in ini section
      PImage result = null;
      if(task.equals("Rectification example")){
        //will call function for rectification
        result = rectify(imageSource, sourcePoints, targetPoints);  
        result.save(saveDestination);
        showAndPause(result, FINAL_DELAY);  
        println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
  }
      else if(task.equals("Composition example")){
        result = composite(imageSource, sourcePoints, imageTarget, targetPoints);
        result.save(saveDestination);
        showAndPause(result, FINAL_DELAY);
      }
      println("Job complete, next job starts in " + FINAL_DELAY/MS_PER_SEC + " seconds");
      //showAndPause(result, FINAL_DELAY);
    }
  } catch(FileNotFoundException e) {
      // Optional, ask the user to specify files, and based on response fork to do proper task
      // (see Processing's 'selectInput' command)
  } catch(IOException e) {
    System.err.println("Failure reading ini file: " + e.getMessage());
    exit();
  }


  println("Done.");
}



///
/// Given an input image and pairs of corresponding points in files, deforms the image
/// TODO: Fill in function
///
PImage rectify(String sourceImagePath, String sourcePointsPath, String targetPointsPath) {
  
  // Load input image, source points and target points
  PImage inputImage = loadImage(sourceImagePath);
  Matrix source = readPoints(sourcePointsPath);
  Matrix target = readPoints(targetPointsPath);
  
  
    // Display source image
  showAndPause(inputImage, FRAME_DELAY, source);

  // Compute homography matrix and its inverse
  Matrix homography = computeH(source, target);
  Matrix invHomography = computeH(target, source);
 /* 
  for(int i = 0; i< 3; i++){
    for(int j =0 ; j<3; j++){
      homography.set(i,j, homography.get(i,j)*-1);
    }
  }
  */
  /*
  println("HOMOGRAPHY");
  println(homography);
  println("INVERSE HOMOGRAPHY");
  println(invHomography);
  */
  // Warp the image and return it
 PImage result = warpImage(inputImage, homography, invHomography);
 //showAndPause(result, FRAME_DELAY, source);
 
 return result;
}

///
/// TODO: Fill in function
///
PImage warpImage(PImage sourceImage, Matrix H, Matrix H_i) {
  // Determine the size of the new image
  no.uib.cipr.matrix.Vector origin = new DenseVector(2);
  no.uib.cipr.matrix.Vector dimensions = new DenseVector(2);
  newImageSize(sourceImage, H, origin, dimensions);
  /*
  println("ORIGIN");
  println(origin);
  println("DIMENSION");
  println(dimensions);
*/
  

  // Create new image of proper size
  PImage newImage = createImage((int)dimensions.get(0), (int)dimensions.get(1), RGB);

  // Loop through the target image and determine which pixels are defined in the source image
  // - In the loop apply the inverse homography to get the image coordinates in the source image
  //   (For this, implement and use 'applyHomography')
  // - If applyHomography returns image coordinates that are defined in the source image, get the
  //   pixel value in the source image of that pixel using bilinear interpolation
  //   (For this, implement and use getColorBilinear)
 for (int row = 0; row < (int)dimensions.get(1); row++){
   for(int col = 0; col < (int)dimensions.get(0); col++){
      Vector points = new DenseVector(new double[]{col, row});
      points.add(origin);
      Vector newPoint = applyHomography(H_i, points);
      color newColor = getColorBilinear(sourceImage, newPoint);
     
      newImage.set(col,row, newColor);
   }//end inner for
 }//end outer for
  return newImage;
}


///
///  Given a homography H and an image, computes the bounding box of the image after applying H.
///
/// TODO: Fill in function
///
///  @param image - Source image
///  @param H - 3x3 homography matrix
///  @param origin - 2D vector defining upper left of new image
///  @param dimensions - 2D vector defining size of new image
///  @post index 0 and 1 of origin and dimensions have been set
///
void newImageSize(PImage image, Matrix H, Vector origin, Vector dimensions) {

  int imageW = image.width;
  int imageH = image.height;
  
  Matrix originalCorners = new DenseMatrix(3, 4);
  originalCorners.set(0,0,0);
  originalCorners.set(1,0,0);
  
  originalCorners.set(0,1,0);
  originalCorners.set(1,1,imageH);
  
  originalCorners.set(0,2,imageW);
  originalCorners.set(1,2,imageH);
  
  originalCorners.set(0,3,imageW);
  originalCorners.set(1,3,0);
  
  for(int i=0; i<4; i++){
    originalCorners.set(2,i,1);
  }//end for
 /*
 println("IMAGEH");
 println(imageH);
 println("IMAGEW");
 println(imageW);
 println("ORIGINAL CORNERS");
 println(originalCorners);
 */
 Matrix newCorners = new DenseMatrix(3,4);
 H.mult(originalCorners, newCorners); 
/* 
 println("NEW CORNERS");
 println(newCorners);
 */
 double minx = Double.POSITIVE_INFINITY;
 double maxx = Double.NEGATIVE_INFINITY;
 double miny = Double.POSITIVE_INFINITY;
 double maxy = Double.NEGATIVE_INFINITY;
 
 for (int j=0; j<4; j++){
   double xVal = newCorners.get(0,j)/newCorners.get(2,j);
   double yVal = newCorners.get(1,j)/newCorners.get(2,j); 
   
   if(xVal > maxx)
      maxx = xVal;
   if(xVal < minx)
      minx = xVal;
   if(yVal > maxy)   
      maxy = yVal;
   if(yVal < miny)
      miny = yVal;
   /*
   if(newCorners.get(0,j)/newCorners.get(2,j) > maxx)
      maxx = newCorners.get(0,j)/newCorners.get(2,j);
   if(newCorners.get(0,j) < minx)
      minx = newCorners.get(0,j);
   if(newCorners.get(1,j) > maxy)
      maxy = newCorners.get(1,j);
   if(newCorners.get(1,j) < miny)
      miny = newCorners.get(1,j);
 */
 
 }
 
 //i guess et origin to new min values?
 origin.set(0,minx);
 origin.set(1,miny);
 
 //same for dimensions. subtractyion
 
 dimensions.set(0, maxx-minx);
 dimensions.set(1, maxy-miny);
 
}



///
/// Composite takes two image paths and two corresponding point list files as the input and
/// returns the image composite
///
/// TODO: Fill in function
///
/// @param sourceImagePath Location of source image
/// @param sourcePointsPath Location of source points file
/// @param targetImagePath Location of target image
/// @param targetPointsPath Location of target points file
///
PImage composite(String sourceImage, String sourcePoints, String targetImage,
                 String targetPoints) {
  
  PImage imposedImage = loadImage(sourceImage);
  PImage mainImage = loadImage(targetImage);
  Matrix source = readPoints(sourcePoints);
  Matrix target = readPoints(targetPoints);
  
  PImage maskImage;
  maskImage = maskImage(mainImage, target);
  

  // testing purposes
  showAndPause(imposedImage, FRAME_DELAY, source);
  showAndPause(mainImage, FRAME_DELAY, target);
  showAndPause(maskImage, FRAME_DELAY, target);

  // Compute (inverse) homography matrix
  Matrix homography = computeH(source, target);
  Matrix invHomography = computeH(target, source);
  /*
  println("Homography");
  println(homography);
  println("Inv Homography");
  println(invHomography);
*/
  // Composite the images and return the resulting image
  // For this, write a function that actually does the composite and name it compositeImages.
  // This function should take the two input images (source and target image) as well as the
  // inverse homography as the input and return a composite image. You will also need to plug in
  // the the target points or a mask to determine composite region.
  
  PImage result = compositeImages(imposedImage, mainImage, invHomography, maskImage);
  return result;
}


PImage maskImage(PImage targetImage, Matrix targetPoints) {
  //From demo progrsm, i gathered i need to make a white square.
  
  
  PImage newSource = createImage(100, 100, RGB);//trial and error came up with 100x100 for dimensions
  
  for (int i = 0; i < newSource.height; i++) {
    for(int j = 0; j < newSource.width; j++){
    newSource.set(i,j, color(255));
  }
  }
  
  
  //i guess put this mask into the target image. almosr same loop as warpImage
  Matrix newSourceCorners= new DenseMatrix(new double[][] {{0, 0},{0, 100},{100, 100},{100, 0}});
  
  Matrix invHomography = computeH(targetPoints, newSourceCorners);
  
  int imageHeight = targetImage.height;
  int imageWidth = targetImage.width;
  PImage mImage = createImage(imageWidth, imageHeight, RGB);
  
  
  for (int row = 0; row < imageHeight; row++) {
    for (int col = 0; col < imageWidth; col++) {
      Vector points = new DenseVector(new double[] {col, row});
      Vector newPoints = applyHomography(invHomography, points);
      color finalColor = getColorBilinear(newSource, newPoints);
      mImage.set(col, row, finalColor);
    }
  }
  
  return mImage;
}

PImage compositeImages(PImage sourceImage, PImage targetImage, Matrix invHomography, PImage maskImage) {
  int imageHeight = targetImage.height;
  int imageWidth = targetImage.width;
  PImage result = createImage(imageWidth, imageHeight, RGB);
  
  //source onto target now
  for (int row = 0; row < imageHeight; row++) {
    for (int col = 0; col < imageWidth; col++) {
      Vector points = new DenseVector(new double[] {col, row});
      Vector newPoints = applyHomography(invHomography, points);
      color sourceColor = getColorBilinear(sourceImage, newPoints);
      //Vector sourceColorVec = color2Vector(sourceColor);
      //Vector targetColorVec = color2Vector(targetImage.get(col, row));
     
      /*
      testing runs at getting blending working
      double alpha = 0.5;
      color alphaColor = maskImage.get(col, row);
      double jdk = red(alphaColor);
      double alpha = jdk/255; 
      */
      //I think that since the mask is white only where i want the face to be, color will be 255,255,255 so i will get one for alpha which will give full value from face and
      //nothing form target and vice versa for outside the white
      double alpha = red(maskImage.get(col,row))/255;
      double finalRed = red(sourceColor)*alpha + red(targetImage.get(col,row))*(1.0-alpha);
      double finalGreen = green(sourceColor)*alpha + green(targetImage.get(col,row))*(1.0-alpha);
      double finalBlue = blue(sourceColor)*alpha + blue(targetImage.get(col, row))*(1.0-alpha);
      
      color finalColor = color((int)finalRed, (int)finalGreen, (int)finalBlue);
      result.set(col, row, finalColor);
    }
  }
  
  return result;
}

//
// -- Functions used by both branches
//

///
/// Compute the homography given the corresponding points
///
/// TODO: Fill in function
///
/// @param source - Nx2 matrix of source points
/// @param target - Nx2 matrix of target points
/// @returns 3x3 homography matrix
///
Matrix computeH(Matrix source, Matrix target) {
 //Make matrices from those passed to function
  Matrix Source = source;
  Matrix Target = target;
  
  
  /*
  Construct a matrix with this form
  sx sy 1 0 0 0 -tx*sx -tx*sy  -tx
  0 0 0 sx sy 1 -ty*sx -ty*sy  -ty
  */
 //why dense matrix?
 Matrix A = new DenseMatrix(2*Source.numRows(), 9);
 A.zero();//zeros the whole matrix
 
 for (int i =0; i < Source.numRows(); i++){
 //need doubles for set method
 double sx = Source.get(i,0);//source xcoord
 double sy = Source.get(i,1);//source ycoord
 double tx = Target.get(i,0);//target xcoord
 double ty = Target.get(i,1);//target ycoord

 int rownum = 2*i;
A.set(rownum,0,sx);
A.set(rownum,1,sy);
A.set(rownum,2,1.0);
A.set(rownum,6,-tx*sx);
A.set(rownum,7,-tx*sy);
A.set(rownum,8,-tx);

rownum++;
A.set(rownum,3,sx);
A.set(rownum,4,sy);
A.set(rownum,5,1.0);
A.set(rownum,6,-ty*sx);
A.set(rownum,7,-ty*sy);
A.set(rownum,8,-ty);
}//end for
 
 Matrix Product = new DenseMatrix(9,9);
 Product = A.transAmult(A,Product);
 Matrix homography = new DenseMatrix(3,3);
 //googled my way to try-catch block. had an unhandled exception thing
 try{
 SymmDenseEVD guess = SymmDenseEVD.factorize(Product);
 double[] vals = guess.getEigenvalues();
 DenseMatrix guess2 = guess.getEigenvectors();
 
 //println(guess2);
 //dense matrix is laid out like an array
 for(int i = 0; i<3;i++){
   for(int j=0; j<3;j++){
     homography.set(i,j, guess2.get((i*3)+j, 0));
   }
 }
//println(homography);
 
 }
 catch(NotConvergedException exception){
    println("Could not be converged");
 }
 return homography;
  
  
}


///
/// Using the matrix 'translation' returns the new point location for p.
/// For example, if given a point in the target image, and the inverse homography this will return
/// the proper point in the original image.
///
/// TODO: Fill in function
///
/// @param homography matrix to apply to the point
/// @param p point to transform
///
no.uib.cipr.matrix.Vector applyHomography(Matrix homography, no.uib.cipr.matrix.Vector p) {
  //x and y from passed point
  Vector origPoint = new DenseVector(new double[] {p.get(0), p.get(1), 1.0});
  //vector for multiplication result
  Vector resultPoint = new DenseVector(3);
  homography.mult(origPoint, resultPoint);
  Vector finalPoint = new DenseVector(2);
  
  finalPoint.set(0, resultPoint.get(0)/resultPoint.get(2));
  finalPoint.set(1, resultPoint.get(1)/resultPoint.get(2));
  return finalPoint;

}


//
// -- Some utility functions ----
//


///
/// Given a point 'p' and an image 'source' returns the bilinearly interpolated color
///
/// TODO: Fill in function
///
/// @param source Image from which to draw pixel values
/// @param p Point (in real coordinates) which will be interpolated
/// @pre p has (at least) 2 values
/// @returns a color value bilinearly interpolated - will be BLACK if p is not within source size
///
color getColorBilinear(PImage source, no.uib.cipr.matrix.Vector p) {
  int R, G, B;

  //  Compute the R,G,B pixel values for image coordinates p in source image
  //  using bilinear interpolation
  double x = p.get(0);
  double y = p.get(1);
  int i = (int) x;
  int j = (int) y;
  double a = x - i;
  double b = y - j;
  
  Vector formulas = new DenseVector(new double[] {(1-a)*(1-b),a *(1-b),a * b,(1-a)* b,});
  
  color ll = source.get(i, j);
  color lr = source.get(i+1, j);
  color ul = source.get(i, j+1);
  color ur = source.get(i+1, j+1);
  Matrix origColors = new DenseMatrix(new double[][] {{red(ll), red(lr), red(ur), red(ul)},
                                           {green(ll), green(lr), green(ur), green(ul)},
                                           {blue(ll), blue(lr), blue(ur), blue(ul)}
                                           });
  
  Vector newColor = new DenseVector(3);
  origColors.mult(formulas, newColor);
  

  
  R = round((float) newColor.get(0));
  G = round((float) newColor.get(1));
  B = round((float) newColor.get(2));
 /* 
  println(R);
  println(G);
  println(B);
*/
  return color(R,G,B);
}


///
/// Reads points into a an Nx2 matrix from a file with N lines
/// File may have commas, or not, should only have 2 values (X and Y) per line
///
/// TODO: Fill in function
///
/// @param filename - Text file with X and Y pairs on each line
/// @pre file exists
/// @returns an Nx2 matrix with the values filled in
///
Matrix readPoints(String filename) {
  String[] lines = loadStrings(filename);
  DenseMatrix matrix = new DenseMatrix(lines.length, 2);
  for(int l = 0; l < lines.length; l++) {
    String[] values = splitTokens(lines[l], ", ");
    matrix.set(l,X,float(values[X]));
    matrix.set(l,Y,float(values[Y]));
  }
  return matrix;
}


///
/// Wrapper that displays an image and waits for the specified number of milliseconds
///
/// @param i image to show
/// @param ms milliseconds to wait
///
void showAndPause(PImage i, int ms) {
  showAndPause(i, ms, new DenseMatrix(0,0));
}


///
/// Displays an image with highlighted points then pauses for the specified number of milliseconds
///
/// @param i image to show
/// @param ms milliseconds to wait
/// @param points points to circle in red
///
void showAndPause(PImage i, int ms, Matrix points) {
  background(0);

  float divideBy = 1.0;
  Matrix newPoints = points.copy();
  if(i.width > width || i.height > height) {
      divideBy = max(float(i.width)/width, float(i.height)/height);
      newPoints.scale(1.0/divideBy);
  }

  int originX = floor((width-i.width/divideBy)/2);
  int originY = floor((height-i.height/divideBy)/2);

  for(int r = 0; r < points.numRows(); r++) {
    newPoints.set(r, X, newPoints.get(r, X) + originX);
        newPoints.set(r, Y, newPoints.get(r, Y) + originY);
  }

  // Show the picture scaled appropriately
  image(i, originX, originY, i.width/divideBy, i.height/divideBy);

  // Show the points
  showPoints(newPoints);
  repaint();
  delay(ms);
}


///
/// Makes small circles on the pallet image to show where the points in 'points' are
///
/// @param points points to make circles at
/// @param x horizontal offset (used for centering images, see showAndPause)
/// @param y vertical offset (used for centering images, see showAndPause)
///
void showPoints(Matrix points){
  stroke(0,0,0);
  fill(255,0,0);
  for(int r = 0; r < points.numRows(); r++) {
    ellipse((float) points.get(r,X), (float)points.get(r,Y), DOT_SIZE, DOT_SIZE);
  }
 
}

